// Twitch Driver
window.TwitchDriver = {
  matches(location) {
    return location.hostname.includes('twitch.tv');
  },
  
  async setMaxQuality(video) {
    const button = document.querySelector('[data-a-target="player-settings-button"]');
    if (button) button.click();
    setTimeout(() => {
      const qualityOptions = document.querySelectorAll('[data-a-target="player-settings-menu"] input[name="quality"]');
      if (qualityOptions.length > 0) {
        qualityOptions[0].click();
        return true;
      }
    }, 100);
    return false;
  },
  
  async disableCaptions(video) {
    const ccButton = document.querySelector('[data-a-target="player-captions-button"]');
    if (ccButton && ccButton.getAttribute('aria-label')?.includes('on')) {
      ccButton.click();
    }
    return true;
  }
};
