// Pornhub Driver
(function() {
  'use strict';

  const QUALITY_PRIORITY = {
    highest: Number.POSITIVE_INFINITY,
    '4320p': 4320,
    '2880p': 2880,
    '2160p': 2160,
    '1440p': 1440,
    '1080p': 1080,
    '960p': 960,
    '720p': 720,
    '480p': 480,
    '360p': 360,
    '240p': 240,
    '144p': 144
  };

  const KEYS_TO_EXPLORE = ['mediaDefinitions', 'mediaDefinition', 'sources', 'source', 'qualities', 'levels', 'items', 'formats', 'files', 'streams', 'playlist'];
  const PLAYER_METHODS = ['setQuality', 'setCurrentQuality', 'changeQuality', 'switchQuality', 'selectQuality', 'setPlaybackQuality'];
  const PLUGIN_KEYS = ['hlsQualitySelector', 'qualitySelector', 'qualityMenu', 'QualityMenu', 'qualityMenuComponent'];
  const MGP_METHOD_FALLBACKS = ['setQuality', 'changeQuality', 'selectQuality', 'chooseQuality', 'setPlaybackQuality', 'set'];

  let loggerInstance = null;

  function getLogger() {
    if (!loggerInstance && typeof AutoHDProLogger === 'function') {
      loggerInstance = new AutoHDProLogger('PornhubDriver');
    }
    return loggerInstance;
  }

  function normalizeQualityLabel(label) {
    if (label == null) {
      return null;
    }
    const normalized = String(label).trim().toLowerCase();
    if (!normalized || normalized === 'auto') {
      return null;
    }
    const match = normalized.match(/(\d{3,4})/);
    if (!match) {
      return null;
    }
    return match[1] + 'p';
  }

  function extractHeight(value) {
    if (value == null) {
      return 0;
    }
    if (typeof value === 'number' && Number.isFinite(value)) {
      return value;
    }
    const match = String(value).match(/(\d{3,4})/);
    return match ? parseInt(match[1], 10) : 0;
  }

  function parseDefinition(definition) {
    if (!definition || typeof definition !== 'object') {
      return null;
    }

    const url = definition.videoUrl || definition.url || definition.src || definition.file || definition.downloadUrl || (definition.embed && definition.embed.src);
    const qualityHint = definition.quality || definition.label || definition.text || definition.id || definition.name || definition.format || definition.resolution || definition.height;
    const height = extractHeight(qualityHint);
    if (!url || !height) {
      return null;
    }

    const label = normalizeQualityLabel(qualityHint) || (height + 'p');
    if (!label) {
      return null;
    }

    return { url, label, height };
  }

  function extractDefinitions(input, definitions, visited) {
    if (!input) {
      return;
    }

    if (typeof input === 'string') {
      const trimmed = input.trim();
      if (trimmed.startsWith('{') || trimmed.startsWith('[')) {
        try {
          extractDefinitions(JSON.parse(trimmed), definitions, visited);
        } catch (_) {}
      }
      return;
    }

    if (typeof input !== 'object') {
      return;
    }

    if (visited.has(input)) {
      return;
    }
    visited.add(input);

    if (Array.isArray(input)) {
      input.forEach(item => extractDefinitions(item, definitions, visited));
      return;
    }

    const parsed = parseDefinition(input);
    if (parsed) {
      const exists = definitions.some(def => def.url === parsed.url || (def.label === parsed.label && def.height === parsed.height));
      if (!exists) {
        definitions.push(parsed);
      }
    }

    for (let i = 0; i < KEYS_TO_EXPLORE.length; i++) {
      const key = KEYS_TO_EXPLORE[i];
      if (Object.prototype.hasOwnProperty.call(input, key)) {
        extractDefinitions(input[key], definitions, visited);
      }
    }
  }

  function collectMediaDefinitions() {
    const definitions = [];
    const visited = new WeakSet();

    extractDefinitions(window.flashvars, definitions, visited);

    try {
      const globalKeys = Object.keys(window);
      for (let i = 0; i < globalKeys.length; i++) {
        const key = globalKeys[i];
        if (!key) {
          continue;
        }
        if (key.toLowerCase().startsWith('flashvars')) {
          extractDefinitions(window[key], definitions, visited);
        }
      }
    } catch (_) {}

    const playerObjList = window.playerObjList;
    if (playerObjList && typeof playerObjList === 'object') {
      Object.values(playerObjList).forEach(entry => extractDefinitions(entry, definitions, visited));
    }

    const qualityNodes = document.querySelectorAll('[data-quality-sources]');
    qualityNodes.forEach(node => {
      const data = node.getAttribute('data-quality-sources');
      if (!data) {
        return;
      }
      try {
        extractDefinitions(JSON.parse(data), definitions, visited);
      } catch (_) {}
    });

    return definitions;
  }

  function selectPreferredDefinition(definitions, preference) {
    if (!definitions.length) {
      return null;
    }
    const normalizedPreference = String(preference || 'highest').toLowerCase();
    const targetHeight = QUALITY_PRIORITY.hasOwnProperty(normalizedPreference)
      ? QUALITY_PRIORITY[normalizedPreference]
      : Number.POSITIVE_INFINITY;

    const sorted = definitions.slice().sort((a, b) => b.height - a.height);
    if (!Number.isFinite(targetHeight)) {
      return sorted[0];
    }

    const candidate = sorted.find(def => def.height >= targetHeight);
    return candidate || sorted[0];
  }

  function buildLabelVariants(label) {
    const variants = new Set();
    const normalized = normalizeQualityLabel(label);
    if (!normalized) {
      return variants;
    }

    const numeric = normalized.replace(/[^0-9]/g, '');
    variants.add(normalized);
    variants.add(normalized.toUpperCase());
    if (numeric) {
      variants.add(numeric);
      variants.add(numeric + 'p');
    }
    return variants;
  }

  function getMgpPlayers() {
    const mgp = window.MGP;
    if (!mgp || !mgp.players || typeof mgp.players !== 'object') {
      return [];
    }

    try {
      return Object.values(mgp.players).filter(Boolean);
    } catch (_) {
      return [];
    }
  }

  function invokeQualityOnTarget(target, variants, logger) {
    if (!target || !variants.size) {
      return false;
    }

    const visited = new Set();
    const queue = [target];

    while (queue.length) {
      const current = queue.shift();
      if (!current || typeof current !== 'object' || visited.has(current)) {
        continue;
      }
      visited.add(current);

      for (const method of MGP_METHOD_FALLBACKS) {
        if (typeof current[method] !== 'function') {
          continue;
        }
        for (const variant of variants) {
          try {
            const result = current[method](variant);
            if (result !== false) {
              logger?.debug?.('Pornhub quality via MGP API', { method, variant });
              return true;
            }
          } catch (_) {}
        }
      }

      try {
        Object.values(current).forEach(value => {
          if (value && typeof value === 'object') {
            queue.push(value);
          }
        });
      } catch (_) {}
    }

    return false;
  }

  function applyViaMgpApi(label, logger) {
    const variants = buildLabelVariants(label);
    if (!variants.size) {
      return false;
    }

    const players = getMgpPlayers();
    for (let i = 0; i < players.length; i++) {
      const player = players[i];
      if (invokeQualityOnTarget(player, variants, logger)) {
        return true;
      }
    }

    return false;
  }

  function isElementVisible(element) {
    if (!element) {
      return false;
    }
    const style = window.getComputedStyle(element);
    return style && style.visibility !== 'hidden' && style.display !== 'none' && style.opacity !== '0';
  }

  function dispatchMouseSequence(target) {
    if (!target) {
      return;
    }

    const events = ['mousedown', 'click', 'mouseup'];
    events.forEach(type => {
      try {
        target.dispatchEvent(new MouseEvent(type, { bubbles: true, cancelable: true }));
      } catch (_) {}
    });
  }

  function openQualityMenu(button) {
    if (!button) {
      return false;
    }

    dispatchMouseSequence(button);
    return true;
  }

  function applyViaMgpMenu(label) {
    const variants = buildLabelVariants(label);
    if (!variants.size) {
      return false;
    }

    const button = document.querySelector('.mgp_button.mgp_btn-quality, .mgp_quality-btn');
    const menu = document.querySelector('.mgp_optionsMenu, .mgp_quality');

    if (!button) {
      return false;
    }

    if (!isElementVisible(menu)) {
      openQualityMenu(button);
    }

    const items = document.querySelectorAll('.mgp_quality li');
    let matched = false;

    items.forEach(item => {
      if (matched || !item) {
        return;
      }

      const normalized = normalizeQualityLabel(item.textContent);
      if (normalized && variants.has(normalized)) {
        try {
          dispatchMouseSequence(item);
          matched = true;
        } catch (_) {}
      }
    });

    return matched;
  }

  function applyViaPlayerObjList(label) {
    const list = window.playerObjList;
    if (!list || typeof list !== 'object') {
      return false;
    }

    const variants = buildLabelVariants(label);
    if (!variants.size) {
      return false;
    }

    let applied = false;

    const attemptOnTarget = (target) => {
      if (!target || applied) {
        return;
      }
      for (let i = 0; i < PLAYER_METHODS.length; i++) {
        const method = PLAYER_METHODS[i];
        if (typeof target[method] !== 'function') {
          continue;
        }
        for (const variant of variants) {
          try {
            const result = target[method](variant);
            if (result !== false) {
              applied = true;
              return;
            }
          } catch (_) {}
        }
      }
    };

    Object.values(list).forEach(entry => {
      if (applied || !entry) {
        return;
      }

      attemptOnTarget(entry);
      attemptOnTarget(entry.player);

      if (applied) {
        return;
      }

      for (let i = 0; i < PLUGIN_KEYS.length; i++) {
        const plugin = entry[PLUGIN_KEYS[i]] || (entry.player && entry.player[PLUGIN_KEYS[i]]);
        if (!plugin) {
          continue;
        }
        attemptOnTarget(plugin);
        if (applied) {
          return;
        }
      }
    });

    return applied;
  }

  function applyViaDom(label) {
    const variants = buildLabelVariants(label);
    if (!variants.size) {
      return false;
    }

    const selectors = [
      '[data-quality]',
      '[data-value]',
      '[data-quality-label]',
      '.qualityMenu__item',
      'button[class*="quality"]'
    ];

    for (let i = 0; i < selectors.length; i++) {
      const elements = document.querySelectorAll(selectors[i]);
      for (let j = 0; j < elements.length; j++) {
        const element = elements[j];
        const raw = element.getAttribute('data-quality') || element.getAttribute('data-value') || element.getAttribute('data-quality-label') || element.textContent;
        const normalized = normalizeQualityLabel(raw);
        if (normalized && variants.has(normalized)) {
          try {
            element.dispatchEvent(new MouseEvent('click', { bubbles: true }));
            return true;
          } catch (_) {}
        }
      }
    }

    return false;
  }

  function setVideoSource(video, definition) {
    if (!video || !definition || !definition.url) {
      return false;
    }

    try {
      const currentSrc = video.currentSrc || video.src || '';
      if (currentSrc === definition.url) {
        return false;
      }

      const currentTime = Number.isFinite(video.currentTime) ? video.currentTime : 0;
      const wasPaused = video.paused;

      const handleLoaded = () => {
        video.removeEventListener('loadedmetadata', handleLoaded);
        try {
          if (Number.isFinite(currentTime)) {
            video.currentTime = currentTime;
          }
          if (!wasPaused) {
            const playResult = video.play();
            if (playResult && typeof playResult.then === 'function') {
              playResult.catch(() => {});
            }
          }
        } catch (_) {}
      };

      video.addEventListener('loadedmetadata', handleLoaded, { once: true });
      video.src = definition.url;
      return true;
    } catch (_) {
      return false;
    }
  }

  function applyQuality(video, definition, logger) {
    if (!definition) {
      return false;
    }

    const label = definition.label;

    if (applyViaMgpApi(label, logger)) {
      return true;
    }

    if (applyViaPlayerObjList(label)) {
      logger?.debug('Applied Pornhub quality via player API', { label });
      return true;
    }

    if (applyViaMgpMenu(label)) {
      logger?.debug('Applied Pornhub quality via quality menu', { label });
      return true;
    }

    if (applyViaDom(label)) {
      logger?.debug('Applied Pornhub quality via DOM interaction', { label });
      return true;
    }

    if (setVideoSource(video, definition)) {
      logger?.debug('Applied Pornhub quality via source swap', { label });
      return true;
    }

    if (window.AutoHDProQuality && typeof window.AutoHDProQuality.forceQualityBySource === 'function') {
      return window.AutoHDProQuality.forceQualityBySource(video, label);
    }

    return false;
  }

  window.PornhubDriver = {
    matches(location) {
      return location.hostname.includes('pornhub');
    },

    async setMaxQuality(video, options) {
      const logger = getLogger();
      const preferredQuality = options && options.preferredQuality ? options.preferredQuality : 'highest';

      const definitions = collectMediaDefinitions();
      if (!definitions.length) {
        logger?.warn('No Pornhub media definitions found');
        return false;
      }

      const target = selectPreferredDefinition(definitions, preferredQuality);
      if (!target) {
        logger?.warn('Unable to determine target quality', { preferredQuality });
        return false;
      }

      logger?.info('Attempting Pornhub quality upgrade', {
        preferredQuality,
        available: definitions.map(def => def.label),
        target
      });

      const result = applyQuality(video, target, logger);
      if (result) {
        logger?.info('Pornhub quality applied', { label: target.label, height: target.height });
      } else {
        logger?.warn('Pornhub quality application failed', { label: target.label, height: target.height });
      }

      return result;
    },

    async disableCaptions(video) {
      if (video && video.textTracks) {
        let disabled = false;
        for (let i = 0; i < video.textTracks.length; i++) {
          const track = video.textTracks[i];
          if (track && track.mode && track.mode.toLowerCase() !== 'disabled') {
            try {
              track.mode = 'disabled';
              disabled = true;
            } catch (_) {}
          }
        }
        if (disabled) {
          return true;
        }
      }

      const selectors = [
        '[data-action="toggle-captions"]',
        '[data-type="captions"]',
        '.js-cc-toggle',
        '.vjs-subs-caps-button'
      ];

      for (let i = 0; i < selectors.length; i++) {
        const element = document.querySelector(selectors[i]);
        if (!element) {
          continue;
        }
        const pressed = element.getAttribute('aria-pressed') || element.getAttribute('aria-checked');
        if (pressed === 'false') {
          return true;
        }
        try {
          element.dispatchEvent(new MouseEvent('click', { bubbles: true }));
          return true;
        } catch (_) {}
      }

      return false;
    }
  };
})();
