// Netflix Driver
window.NetflixDriver = {
  matches(location) {
    return location.hostname.includes('netflix.com');
  },
  
  async setMaxQuality(video) {
    const setQuality = () => {
      const player = window.netflix?.appContext?.state?.playerApp?.getAPI?.();
      if (player && player.setVideoBitrateRange) {
        player.setVideoBitrateRange(25000, 25000);
        return true;
      }
      return false;
    };
    return setQuality();
  },
  
  async disableCaptions(video) {
    const player = window.netflix?.appContext?.state?.playerApp?.getAPI?.();
    if (player && player.setTextTrack) {
      player.setTextTrack(null);
      return true;
    }
    return false;
  }
};
