# AutoHDPro - Chrome Extension

## 🎬 Transform Your Video Experience

AutoHDPro is a powerful Chrome extension that automatically enhances video quality and manages captions across 100+ video platforms. Whether you're watching educational content, streaming entertainment, or browsing social media, AutoHDPro ensures you always get the best possible video experience.

## ✨ Key Features

### 🚀 Automatic Quality Enhancement
- **Forces Highest Quality**: Automatically sets videos to the highest available resolution
- **Smart Detection**: AI-powered video detection works with dynamic content and single-page applications
- **Universal Compatibility**: Works on 100+ video sites including YouTube, Netflix, Twitch, Vimeo, and more
- **Real-time Processing**: Enhances videos as they load, no page refresh required

### 📺 Caption Management
- **Auto-Disable Captions**: Automatically turns off captions for a cleaner viewing experience
- **Smart Detection**: Identifies and disables various caption systems across different platforms
- **Toggle Control**: Easy on/off toggle in the extension popup

### 🎯 Platform-Specific Optimization
- **YouTube**: Optimized for YouTube's quality selection system
- **Netflix**: Enhanced for Netflix's adaptive streaming
- **Twitch**: Optimized for live streaming quality
- **Vimeo**: Enhanced for Vimeo's player controls
- **Adult Sites**: Safe, respectful enhancement for adult content platforms
- **Educational Platforms**: Works with Khan Academy, Coursera, Udemy, and more

### ⚙️ Advanced Settings
- **Quality Preferences**: Choose your preferred quality level (4K, 1080p, 720p, etc.)
- **Site-Specific Overrides**: Customize settings for individual websites
- **Global Toggle**: Enable/disable the extension with one click
- **Statistics Tracking**: See how many videos have been enhanced

## 🛡️ Privacy & Security

- **100% Local Processing**: All enhancement happens in your browser
- **No Data Collection**: We don't collect, store, or transmit any personal data
- **No Tracking**: No analytics, no user behavior tracking
- **Minimal Permissions**: Only requests necessary browser permissions
- **Open Source**: Full source code available for transparency

## 🧩 Multi-Browser Builds

### Chrome (stable)
- Build: `bash build.sh`
- Output: `autohdpro-chrome-extension.zip` (and a synced copy in `../public/` for the web download)
- Install via `chrome://extensions` (Developer Mode → drag the ZIP) or publish to the Chrome Web Store.

### Firefox (MV3 preview)
- Build: `bash build-firefox.sh`
- Output: `autohdpro-firefox-extension.zip`
- Load via [`web-ext`](https://extensionworkshop.com/documentation/develop/web-ext-command-reference/) or Firefox Nightly (about:debugging → “This Firefox” → “Load Temporary Add-on”).
- **Heads-up:** Firefox’s Manifest V3 and background service workers still require Nightly with `dom.webextensions.manifestV3.enabled=true`. Quality enforcement works, but expect rough edges until Mozilla’s MV3 APIs stabilize.

### Safari (convert with Xcode)
- Use Apple’s converter: `xcrun safari-web-extension-converter ../chrome-extension --project-location ../safari-extension`.
- Follow the generated Xcode project to build a signed `.app`/`.safariextz`. See `SAFARI.md` for detailed steps and gotchas.

## 🚀 Installation & Setup

### Quick Install
1. Click "Add to Chrome" on the Chrome Web Store
2. Click "Add Extension" when prompted
3. The extension will automatically start working on supported sites

### First-Time Setup
1. Click the AutoHDPro icon in your Chrome toolbar
2. Toggle the extension ON
3. Configure your preferred settings:
   - Enable "Auto HD Quality" for automatic quality enhancement
   - Enable "Disable Captions" to turn off captions globally
   - Choose your preferred quality level
4. Visit any supported video site and enjoy enhanced quality!

## 📱 Supported Platforms

### 🎬 Streaming Services
- **YouTube** (youtube.com, youtu.be)
- **Netflix** (netflix.com)
- **Twitch** (twitch.tv)
- **Vimeo** (vimeo.com)
- **Dailymotion** (dailymotion.com)
- **Hulu** (hulu.com)
- **Disney+** (disneyplus.com)
- **Amazon Prime Video** (primevideo.com)

### 🎓 Educational Platforms
- **Khan Academy** (khanacademy.org)
- **Coursera** (coursera.org)
- **Udemy** (udemy.com)
- **edX** (edx.org)
- **LinkedIn Learning** (linkedin.com/learning)

### 📱 Social Media
- **Facebook** (facebook.com)
- **Twitter/X** (twitter.com, x.com)
- **Instagram** (instagram.com)
- **TikTok** (tiktok.com)
- **LinkedIn** (linkedin.com)

### 🌐 Adult Content Sites
- **Pornhub** (pornhub.com)
- **Xhamster** (xhamster.com)
- **XVideos** (xvideos.com)
- **RedTube** (redtube.com)
- **YouPorn** (youporn.com)

*Note: Adult content sites are supported with appropriate content warnings. Please ensure you're of legal age and comply with local laws.*

## ⚙️ How It Works

### 1. Video Detection
AutoHDPro uses advanced DOM monitoring to detect video elements as they appear on the page, including:
- Standard HTML5 video elements
- Embedded players (YouTube, Vimeo, etc.)
- Dynamic content loaded via JavaScript
- Single-page application navigation

### 2. Quality Enhancement
The extension automatically:
- Identifies available quality levels
- Selects the highest available resolution
- Applies quality settings using platform-specific APIs
- Monitors for quality changes and re-applies settings

### 3. Caption Management
Smart caption detection and disabling:
- Identifies various caption systems (HTML5, Flash, custom players)
- Disables captions at the player level
- Handles dynamic caption loading
- Provides manual toggle control

## 🎛️ Extension Interface

### Popup Controls
- **Main Toggle**: Enable/disable the extension
- **Statistics**: View enhanced video count
- **Settings Panel**:
  - Auto HD Quality toggle
  - Disable Captions toggle
  - Quality preference selector
  - Site-specific settings button

### Site Override Settings
- **Per-Site Control**: Customize settings for individual websites
- **Quality Override**: Set different quality preferences per site
- **Feature Toggle**: Enable/disable specific features per site

## 🔧 Technical Details

### Architecture
- **Manifest V3**: Uses the latest Chrome extension API
- **Content Scripts**: Inject into web pages for video detection
- **Service Worker**: Manages extension lifecycle and communication
- **Modular Design**: Platform-specific drivers for optimal compatibility

### Performance
- **Lightweight**: Minimal impact on browser performance
- **Efficient Detection**: Smart algorithms prevent unnecessary processing
- **Memory Optimized**: Automatic cleanup of unused resources
- **Fast Loading**: Optimized scripts load quickly

### Compatibility
- **Chrome 88+**: Requires Chrome version 88 or higher
- **All Video Formats**: Works with MP4, WebM, HLS, DASH, and more
- **Cross-Platform**: Works on Windows, Mac, Linux, and Chrome OS

## 🐛 Troubleshooting

### Common Issues

**Extension not working on a site:**
1. Check if the site is in our supported list
2. Try refreshing the page
3. Check if the extension is enabled
4. Verify the site isn't in your disabled sites list

**Quality not changing:**
1. Ensure "Auto HD Quality" is enabled
2. Check if the video has multiple quality options
3. Try refreshing the page
4. Some live streams may not support quality changes

**Captions still showing:**
1. Ensure "Disable Captions" is enabled
2. Try manually toggling captions off on the video player
3. Some platforms may require manual intervention

### Getting Help
- **Documentation**: Visit our comprehensive help center
- **Support**: Contact us through the Chrome Web Store
- **Bug Reports**: Report issues via our GitHub repository
- **Feature Requests**: Suggest new features through our feedback form

## 🔄 Updates & Maintenance

### Automatic Updates
- The extension updates automatically through Chrome
- New features and improvements are added regularly
- Bug fixes are deployed as soon as they're ready

### Version History
- **v1.0.0**: Initial release with core functionality
- **v1.0.1**: Bug fixes and performance improvements
- **v1.0.2**: Added support for additional platforms
- **v1.1.0**: Enhanced quality detection algorithms

## 📊 Statistics & Analytics

### What We Track (Locally)
- Number of videos enhanced
- Sites where enhancement was applied
- Performance metrics (load times, success rates)

### What We DON'T Track
- Personal information
- Video content or titles
- Browsing history
- User behavior patterns
- Any data that could identify you

## 🚀 Future Features

### Coming Soon
- **Firefox Support**: Extension for Firefox browser
- **Safari Support**: Extension for Safari browser
- **Advanced Quality Controls**: More granular quality settings
- **Playback Speed Optimization**: Smart speed adjustment

### Planned Features
- **Mobile App**: Companion mobile application
- **Cloud Sync**: Settings synchronization across devices
- **Custom Profiles**: User-defined enhancement profiles
- **AI Enhancement**: Machine learning-based quality prediction

## 🤝 Contributing

We welcome contributions from the community!

### How to Contribute
1. **Report Bugs**: Use our issue tracker
2. **Suggest Features**: Submit feature requests
3. **Code Contributions**: Submit pull requests
4. **Documentation**: Help improve our documentation
5. **Testing**: Help test on different platforms

### Development Setup
1. Clone our GitHub repository
2. Load the extension in developer mode
3. Make your changes
4. Test thoroughly
5. Submit a pull request

## 📄 Legal & Compliance

### Terms of Service
- Use the extension responsibly
- Respect website terms of service
- Don't use for illegal activities
- Report bugs and issues promptly

### Privacy Policy
- No personal data collection
- No tracking or analytics
- Local processing only
- Open source transparency

### Content Warnings
- Adult content sites are supported
- Users must be of legal age
- Comply with local laws and regulations
- Use responsibly and appropriately

## 🌟 Why Choose AutoHDPro?

### ✅ Advantages
- **Universal Compatibility**: Works on 100+ video sites
- **Automatic Enhancement**: No manual intervention required
- **Privacy-Focused**: No data collection or tracking
- **Lightweight**: Minimal performance impact
- **Regular Updates**: Continuous improvement and new features
- **Open Source**: Transparent and auditable code
- **Free**: No cost, no premium features, no ads

### 🆚 vs. Competitors
- **Better Detection**: More accurate video detection algorithms
- **Wider Support**: More platforms than any other extension
- **Privacy-First**: No data collection unlike many competitors
- **Active Development**: Regular updates and improvements
- **Community-Driven**: Open source with community contributions

## 📞 Support & Contact

### Getting Help
- **Chrome Web Store**: Leave a review or contact us
- **GitHub Issues**: Report bugs and request features
- **Email Support**: support@autohdpro.com
- **Documentation**: Complete guides and tutorials

### Community
- **GitHub Discussions**: Join our developer community
- **Discord Server**: Chat with other users
- **Reddit Community**: r/AutoHDPro
- **Twitter**: @AutoHDPro

---

## 🎯 Ready to Enhance Your Video Experience?

**Install AutoHDPro today and never settle for low-quality videos again!**

[Install from Chrome Web Store](https://chrome.google.com/webstore/detail/AutoHDPro) | [View Source Code](https://github.com/yourusername/AutoHDPro) | [Report Issues](https://github.com/yourusername/AutoHDPro/issues)

---

*AutoHDPro - Where every video deserves to be seen in its best quality* 🎬✨

**Version**: 1.0.0  
**Last Updated**: December 2024  
**Chrome Version**: 88+  
**Size**: 2.1 MB  
**Languages**: English (more coming soon)
